within ;
model DiscBrake

  parameter Real max_force(start = 1.0) "max breaking force";
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a
    annotation (Placement(transformation(extent={{-100,-10},{-80,10}})));
  Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_b annotation (
      Placement(transformation(extent={{64,-10},{84,10}}),iconTransformation(
          extent={{64,-10},{84,10}})));

  Modelica.Blocks.Interfaces.RealInput u annotation (Placement(transformation(
        extent={{20,-20},{-20,20}},
        rotation=90,
        origin={-6,76})));
  Modelica.Mechanics.Rotational.Components.Brake brake(fn_max=max_force)
    annotation (Placement(transformation(extent={{-14,-10},{6,10}})));
equation
  connect(flange_a, brake.flange_a) annotation (Line(
      points={{-90,0},{-14,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(brake.flange_b, flange_b) annotation (Line(
      points={{6,0},{74,0}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(brake.f_normalized, u) annotation (Line(
      points={{-4,11},{-4,76},{-6,76}},
      color={0,0,127},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Icon(graphics),
    Diagram(graphics));
end DiscBrake;
